<?php

function gettnxtype($data){
    return '<div class="site-badge primary-bg">'.$data.'</div>';
}
function gettnxCharge($data){
    return $data.' USD';
}
function gettnxDesc($data,$date){
    $formattedDate = date("M d Y H:i", strtotime($date));
    return '<div class="table-description"><i class="anticon anticon-check-square icon" style="font-size:1.5em"></i><div class="description"><strong>'.$data.'</strong><div class="date">'.$formattedDate.'</div></div>';
}
function gettnxAmt($type, $data){
    if($type == 'Manual Deposit'){
        return '<strong class="green-color">+'.$data.' USD</strong>';
    }
    if($type == 'Withdrawal'){
        return '<strong class="red-color">-'.$data.' USD</strong>';
    }
    if($type == 'Funds Transfer'){
        return '<strong class="red-color">-'.$data.' USD</strong>';
    }
    if($type == 'Signup Bonus'){
        return '<strong class="green-color">+'.$data.' USD</strong>';
    }
    if($type == 'Investment'){
        return '<strong class="green-color">+'.$data.' USD</strong>';
    }
    if($type == 'Wallet Transfer'){
        return '<strong class="green-color">+'.$data.' USD</strong>';
    }
    if($type == 'Referal Bonus'){
        return '<strong class="green-color">+'.$data.' USD</strong>';
    }
    if($type == 'Bot Purchase'){
        return '<strong class="red-color">-'.$data.' USD</strong>';
    }
}
function getTradeResult($amt, $result){
    if($result == 'profit'){
        return '<strong class="green-color">+'.number_format($amt).' USD</strong>';
    }
    if($result == 'loss'){
        return '<strong class="red-color">-'.number_format($amt).' USD</strong>';
    }
}
function gettmarkt($data){
    if($data == 'buy'){
        return '<div class="site-badge success">BUY</div>';
    }
    if($data == 'sell'){
        return '<div class="site-badge failed">SELL</div>';
    }
}
function gettnxStat($data){
    if($data == 'success'){
        return '<div class="site-badge success">Success</div>';
    }
    if($data == 'pending'){
        return '<div class="site-badge warnning">Pending</div>';
    }
    if($data == 'failed'){
        return '<div class="site-badge failed">Failed</div>';
    }
    if($data == 'trading'){
        return '<div class="site-badge" style="background-color:#0a0ac1;">Trading...</div>';
    }
}
function getUserTemplate($url, $page = false){
    // if(isset($page['page'])){
    //     $page = $page['page'];
    // }
    // $toast_alert = toast_alert();
    if(checkAuth()){
        // print_r($_SESSION);
    $assist = new assist($_SESSION['customer_email']);
    $assist->checkTrades();
    // print_r($assist->get_userdata());
    extract($assist->get_userdata());
    $get_plans = $assist->get_plans();
    $get_wallets = $assist->get_wallets();
    $get_transactions = $assist->get_transactions();
    $get_deposit = $assist->get_transactions('Manual Deposit');
    $get_invest = $assist->get_transactions('Investment');
    $get_withdraw = $assist->get_transactions('Withdrawal');
    $get_funds_transfer = $assist->get_transactions('Funds Transfer');
    $get_bot_history = $assist->get_transactions('Bot Purchase');
    $get_withdraw_m = $assist->get_withdraw_m();
    $get_trade_data = $assist->get_trade_data();
    $getJSONActiveTrade = $assist->getJSONActiveTrade();
    // print_r($assist->get_plans());
    // Convert PHP array to desired JSON structure
$jsonArray = [];
$transactionData = [];
$depositData = [];
$withdrawData = [];
$investData = [];
$tradeData = [];
$fundTransferData = [];
$botHistory = [];
foreach ($get_plans as $item) {
    $jsonArray[strval($item['plan_id'])] = [
        "plan_name" => $item['plan_name'],
        "amount_range" => $item['plan_investment'],
        "return_interest" => $item['plan_percent'] . "%",
        "number_period" => $item['plan_period'],
        "capital_back" => $item['plan_capital_back'], // Capitalize the first letter
        "invest_amount" => 0 // Assuming a static value for the example
    ];
}
foreach ($get_trade_data as $trade_data) {
    // $jsonArray[strval($item['investment_id'])]
    $newTItem = [
        "Pairs" => $trade_data['trading_pairs'],
        "Market" => $trade_data['trade_market'],
        "Type" => gettmarkt($trade_data['trade_type']),
        "PnL" => getTradeResult($trade_data['final_amount'],$trade_data['trade_result']),
        "Execution" => $trade_data['execution'], // Capitalize the first letter
        "Timeline" => $trade_data['investment_time'].' Minute'
    ];
        array_push($tradeData, $newTItem);
}
// print_r($get_invest);
foreach ($get_invest as $item) {
    $Xplan = $jsonArray[$item['plan_id']];
    $newItem = [
        "icon" => '<img class="investment-plan-icon" height="50px"  src="/images'.'/'.$item['plan_id'].'.png" >',
        "schema" => $Xplan['plan_name'],
        "roi" => $Xplan['return_interest'],
        "profit" => gettnxAmt($item['type'],$item['final_amount']),
        "capital_back" => $Xplan['capital_back'], // Capitalize the first letter
        "timeline" => $Xplan['number_period'] // Assuming a static value for the example
    ];
    array_push($investData, $newItem);
}


foreach ($get_transactions as $item) {
    $item['amount'] = gettnxAmt($item['type'],$item['amount']);
    $item['type'] = gettnxtype($item['type']);
    $item['status'] = gettnxStat($item['status']);
    $item['description'] = gettnxDesc($item['description'],$item['created_at']);
    $item['charge'] = gettnxCharge($item['charge']);
    array_push($transactionData, $item);
}
foreach ($get_deposit as $item) {
    $item['amount'] = gettnxAmt($item['type'],$item['amount']);
    $item['type'] = gettnxtype($item['type']);
    $item['status'] = gettnxStat($item['status']);
    $item['description'] = gettnxDesc($item['description'],$item['created_at']);
    $item['charge'] = gettnxCharge($item['charge']);
    array_push($depositData, $item);
}
foreach ($get_funds_transfer as $item) {
    $item['amount'] = gettnxAmt($item['type'],$item['amount']);
    $item['type'] = gettnxtype($item['type']);
    $item['status'] = gettnxStat($item['status']);
    $item['description'] = gettnxDesc($item['description'],$item['created_at']);
    $item['charge'] = gettnxCharge($item['charge']);
    array_push($fundTransferData, $item);
}
foreach ($get_bot_history as $item) {
    $item['amount'] = gettnxAmt($item['type'],$item['amount']);
    $item['type'] = gettnxtype($item['type']);
    $item['status'] = gettnxStat($item['status']);
    $item['description'] = gettnxDesc($item['description'],$item['created_at']);
    $item['charge'] = gettnxCharge($item['charge']);
    array_push($botHistory, $item);
}
foreach ($get_withdraw as $item) {
    $item['amount'] = gettnxAmt($item['type'],$item['amount']);
    $item['type'] = gettnxtype($item['type']);
    $item['status'] = gettnxStat($item['status']);
    $item['description'] = gettnxDesc($item['description'],$item['created_at']);
    $item['charge'] = gettnxCharge($item['charge']);
    array_push($withdrawData, $item);
}
$walletsArr = [];
foreach ($get_wallets as $item) {
$new_payment_details = "<div class=\"site-card\"><div class=\"site-card-header\"><h3 class=\"title\">".$item['wallet_name']." Wallet Address</h3></div><div class=\"site-card-body\"><div class=\"referral-link\"><div class=\"referral-link-form\"><input type=\"text\" value=".$item['wallet_address']." id=\"uniqueAddress\"/><button type=\"button\" onclick=\"copyAddr()\"><i class=\"anticon anticon-copy\"></i><span id=\"copy\">Copy Address</span><input id=\"copied\" hidden value=\"Copied\"></button></div></div></div></div>";
   $ArrPlus = [
"credentials" => "<div class=\"col-xl-12 col-md-12\">\n<div class=\"frontend-editor-data\">\n".$new_payment_details."\n\n<p><br></p>\n</div>\n</div>\n\n<div class=\"col-xl-12 col-md-12\">\n<div class=\"body-title\">Upload proof</div>\n<div class=\"wrap-custom-file\">\n<input\n type=\"file\"\n name=\"manual_data\"\n id=\"1\"\n accept=\".gif, .jpg, .png\"\n  required \/>\n <label for=\"1\">\n <img\n class=\"upload-icon\"\n src=\"/images/upload.svg\"\n alt=\"\"\n/>\n<span>Select Upload proof</span>\n</label>\n</div>\n</div>\n\n\n",
"credentials_old" => "<div class=\"col-xl-12 col-md-12\">\n<div class=\"frontend-editor-data\">\n<p>Pay into the ".$item['wallet_name']." address below:</p>\n\n<p>".$item['wallet_address']."</p>\n\n<p><br></p>\n</div>\n</div>\n\n<div class=\"col-xl-12 col-md-12\">\n<div class=\"body-title\">Upload proof</div>\n<div class=\"wrap-custom-file\">\n<input\n type=\"file\"\n name=\"manual_data\"\n id=\"1\"\n accept=\".gif, .jpg, .png\"\n  required \/>\n <label for=\"1\">\n <img\n class=\"upload-icon\"\n src=\"/images/upload.svg\"\n alt=\"\"\n/>\n<span>Select Upload proof</span>\n</label>\n</div>\n</div>\n\n\n",
"payment_details" => "<p>Pay into the ".$item['wallet_name']." address below:</p><p>".$item['wallet_address']."</p><p><br></p>",
"payment_details_new" => "<div class=\"site-card\"><div class=\"site-card-header\"><h3 class=\"title\">".$item['wallet_name']." Wallet Address</h3></div><div class=\"site-card-body\"><div class=\"referral-link\"><div class=\"referral-link-form\"><input type=\"text\" value=".$item['wallet_address']." id=\"uniqueAddress\"/><button type=\"submit\" onclick=\"copyAddr()\"><i class=\"anticon anticon-copy\"></i><span id=\"copy\">Copy Url</span><input id=\"copied\" hidden value=\"Copied\"></button></div></div></div></div>"
];
$walletsArr[strval($item['wallet_symbol'])] = array_merge($item, $ArrPlus);
}
$walletSelect = '<option value="">Select Gateway Method</option>';
 foreach($get_wallets as $wallets) {
   $walletSelect.='<option value="'.$wallets['wallet_symbol'].'" >'.$wallets['wallet_name'].'</option>'; 
 }
 $walletSelect = '<td><strong>Payment Method:</strong></td><td><div class="input-group mb-0"><select class="site-nice-select" aria-label="Default select example" name="gateway_code" id="gatewaySelect" required id="selectWallet">'.$walletSelect.'</select></div></td>';
// Convert the new array to a JSON string
$Dcurrency = 'USD';
$fundTransferData = json_encode($fundTransferData, JSON_PRETTY_PRINT);
$investData = json_encode($investData, JSON_PRETTY_PRINT);
$tradeData = json_encode($tradeData, JSON_PRETTY_PRINT);
$withdrawData = json_encode($withdrawData, JSON_PRETTY_PRINT);
$depositData = json_encode($depositData, JSON_PRETTY_PRINT);
$transactionData = json_encode($transactionData, JSON_PRETTY_PRINT);
$jsonString = json_encode($jsonArray, JSON_PRETTY_PRINT);
$walletsArr = json_encode($walletsArr, JSON_PRETTY_PRINT);
$botHistory = json_encode($botHistory, JSON_PRETTY_PRINT);
$getJSONActiveTrade = json_encode($getJSONActiveTrade, JSON_PRETTY_PRINT);
$current_bot_plan = $assist->get_bot_plans(intval($current_bot_plan_id));
$is_total_day_limit_true = $assist->is_total_day_limit_true($current_bot_plan_id);
    require 'layout/dashboard-header.php';
    require "dashboard/$url.php";
    require 'layout/dashboard-footer.php';
    }
}
