<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\RequestHandlerInterface as RequestHandler;
use Slim\Routing\RouteCollectorProxy;
use Slim\Factory\AppFactory;
use Psr\Log\LoggerInterface;
 use Slim\Psr7\Response as SlimReponse;

require __DIR__ . '/vendor/autoload.php';

function checkAuth($email=null){
    if(explode('/', $_SERVER['REQUEST_URI'])[1] == 'user'){
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    if(isset($_SESSION['goodloginistrue']) && isset($_SESSION['customer_email'])){
    if($_SESSION['goodloginistrue'] != true && $_SESSION['customer_email'] == ''){
        $authenticated = false;
    }else{
        $authenticated = true;
        }
if($email){
    if($_SESSION['goodloginistrue'] == true && $_SESSION['customer_email'] == $email){
        $authenticated = true;
    }else{
        $authenticated = false;
        } 
}

}else{
    $authenticated = false;
}
        return $authenticated;
}
}

require __DIR__ . '/app/assist.php';
require __DIR__ . '/app/controller.php';
require __DIR__ . '/app/formatting.php';

$app = AppFactory::create();

function addtemplate($url, $response=null,$param=null){
    $services = json_decode(file_get_contents('data/services.json'), true);
    $isLoginSuccessful = false;
    if($url == 'views/single-services.php'){
       $active_service = [];
       
       foreach($services as $service){
       if('/services'.'/'.str_replace(' ','_',$service['name']) == $_SERVER['REQUEST_URI']){
        $active_service = $service;
        break;
       }
      }
      
      if(empty($active_service)){
        return $response->withHeader('Location', '/services')->withStatus(302);
      }
   }
   include __DIR__ . '/app/login.php';
   if($isLoginSuccessful){
        return $response->withHeader('Location', '/user/dashboard')->withStatus(302);
      }
   
     ob_start();
     include 'layout/header.php';
     include "$url";
     include 'layout/footer.php';
     $content = ob_get_clean();
     $response->getBody()->write($content);   
     return $response;  
 }
$app->group('/user', function (RouteCollectorProxy $group) {
        $group->any('/', function ($request, $response, $args) {
    getUserTemplate('dashboard');
    return $response;
});
$group->any('/dashboard', function ($request, $response, $args) {
    getUserTemplate('dashboard');
    return $response;
});
$group->any('/invest-logs', function ($request, $response, $args) {
    getUserTemplate('invest-logs');
    return $response;
});
$group->any('/trade-logs', function ($request, $response, $args) {
    getUserTemplate('trade-logs');
    return $response;
});
$group->any('/bot-logs', function ($request, $response, $args) {
    getUserTemplate('b-logs');
    return $response;
});
$group->any('/statistics', function ($request, $response, $args) {
    getUserTemplate('statistics');
    return $response;
});
$group->any('/schema-preview/{plan_id}', function ($request, $response, $args) {
    getUserTemplate('schema-preview', $args);
    return $response;
});

$group->group('/deposit', function (RouteCollectorProxy $groupIn) {
    $groupIn->any('/log',function (Request $request, Response $response, $args) {
        getUserTemplate('log-d');
        return $response;
    });
    $groupIn->any('',function (Request $request, Response $response, $args) {
        getUserTemplate('deposit');
        return $response;
    });
});
$group->group('/withdraw', function (RouteCollectorProxy $groupIn) {
    $groupIn->any('/log',function (Request $request, Response $response, $args) {
        getUserTemplate('log-w');
        return $response;
    });
    $groupIn->any('',function (Request $request, Response $response, $args) {
        getUserTemplate('withdraw');
        return $response;
    });
});
$group->group('/support-ticket', function (RouteCollectorProxy $groupIn) {
    $groupIn->any('/index',function (Request $request, Response $response, $args) {
        getUserTemplate('index-s');
        return $response;
    });
    $groupIn->any('/new',function (Request $request, Response $response, $args) {
        getUserTemplate('new-t');
        return $response;
    });
});
$group->group('/send-money', function (RouteCollectorProxy $groupIn) {
    $groupIn->any('/log',function (Request $request, Response $response, $args) {
        getUserTemplate('log-s');
        return $response;
    });
    $groupIn->any('',function (Request $request, Response $response, $args) {
        getUserTemplate('send-money');
        return $response;
    });
});
$group->any('/schemas',function (Request $request, Response $response, $args) {
    getUserTemplate('schemas');
    return $response;
});
$group->any('/kyc',function (Request $request, Response $response, $args) {
    getUserTemplate('kyc');
    return $response;
});
$group->any('/settings',function (Request $request, Response $response, $args) {
    getUserTemplate('settings');
    return $response;
});

$group->any('/wallet-exchange',function (Request $request, Response $response, $args) {
    getUserTemplate('wallet-exchange');
    return $response;
});
$group->any('/ranking-badge',function (Request $request, Response $response, $args) {
    getUserTemplate('ranking-badge');
    return $response;
});
$group->any('/referral',function (Request $request, Response $response, $args) {
    getUserTemplate('referral');
    return $response;
});
$group->any('/loan',function (Request $request, Response $response, $args) {
    getUserTemplate('loan');
    return $response;
});
$group->any('/wallet-connect',function (Request $request, Response $response, $args) {
    getUserTemplate('wallet-connect');
    return $response;
});
$group->any('/change-password',function (Request $request, Response $response, $args) {
    getUserTemplate('change-password');
    return $response;
});
$group->any('/transactions',function (Request $request, Response $response, $args) {
    getUserTemplate('transactions');
    return $response;
});
})->add(function (Request $request,  RequestHandler $handler){
    if(!checkAuth()){
        // User is not authenticated, redirect them
        $response = new SlimReponse();
        return $response->withHeader('Location', '/login')->withStatus(302);
    }
    // User is authenticated, proceed with the request
    return $handler->handle($request);
});

$app->any('/logout', function ($request, $response, $args) {
    session_start();
    session_unset();
    session_destroy();
    return $response
    ->withHeader('Location', '/login')
    ->withStatus(302);
});
 $app->any('/', function (Request $request, Response $response, $args) {
     return addtemplate('views/index.php', $response);
 });
 $app->any('/services', function (Request $request, Response $response, $args) {
     return addtemplate('views/services.php',$response);
 });
 $app->any('/services/{service}', function (Request $request, Response $response, $args) {
    return addtemplate('views/single-services.php', $response);
 });
 $app->any('/contact', function (Request $request, Response $response, $args) {
     return addtemplate('views/contact.php',$response);
 });
 $app->any('/register', function (Request $request, Response $response, $args) {
    return addtemplate('views/signup.php',$response);
 });
 $app->any('/about', function (Request $request, Response $response, $args) {
    return addtemplate('views/about.php',$response);
 });
 $app->any('/login', function (Request $request, Response $response, $args) {
    return addtemplate('views/login.php',$response);
 });
$app->any('/admin',function (Request $request, Response $response, $args) {
    header('location:admin');
    return $response;
});
$app->any('/input.php',function (Request $request, Response $response, $args) {
    header('location:input.php');
    return $response;
}); 
$app->run();